<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class City extends Model 
{

    protected $table = 'cities';
    public $timestamps = true;

    public function governates()
    {
        return $this->belongsTo('App\Models\Governate', 'governate_id');
    }

    public function clients()
    {
        return $this->belongsTo('App\Models\Client');
    }

    public function donation_requests()
    {
        return $this->hasMany('App\Models\DonationRequest');
    }

}